using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.GUI.controls;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Looks up a VistA user in a supplied list (previously retrieved from a currently connected VistA system). 
	/// </summary>
	public class DlgWindowsUsers : gov.va.med.vbecs.GUI.VbecsBaseForm	
	{
		private VbecsWindowsUser _selectedUser;
		private VbecsUser _initiallySelectedUser;

		private System.Windows.Forms.GroupBox grpVistAUsers;
		private System.Windows.Forms.ColumnHeader colName;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.ListView lvNtUsers;
		private System.Windows.Forms.ColumnHeader colNtLogin;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#region WindowsUserListViewItem Implementation

		private class WindowsUserListViewItem : ListViewItem
		{
			public readonly VbecsWindowsUser WindowsUser;
			private const string UnnamedUserNameSubst = "<No Name Available>";

			public WindowsUserListViewItem( VbecsWindowsUser windowsUser )
			{
				if( windowsUser == null )
					throw( new ArgumentNullException( "windowsUser" ) );

				WindowsUser = windowsUser;

				this.SubItems[0].Text = WindowsUser.LoginId;
				this.SubItems.Add( ( WindowsUser.FullName == null || WindowsUser.FullName.Length < 1 ) ? UnnamedUserNameSubst : WindowsUser.FullName );
			}
		}

		#endregion

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgWindowsUsers()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			_selectedUser = null;
			DialogResult = DialogResult.Cancel;

			btnOK.Text = "&OK";
			btnCancel.Text = "&Cancel";			
		}

		/// <defects>251166</defects>
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="userToSelect"></param>
		public DlgWindowsUsers(VbecsUser userToSelect )
			: this()
		{
			_initiallySelectedUser = userToSelect;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.grpVistAUsers = new System.Windows.Forms.GroupBox();
			this.lvNtUsers = new System.Windows.Forms.ListView();
			this.colNtLogin = new System.Windows.Forms.ColumnHeader();
			this.colName = new System.Windows.Forms.ColumnHeader();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpVistAUsers.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(332, 30);
			this.vbecsLogo1.Title = "Windows Users";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 300);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpVistAUsers
			// 
			this.grpVistAUsers.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpVistAUsers.Controls.Add(this.lvNtUsers);
			this.grpVistAUsers.Location = new System.Drawing.Point(4, 32);
			this.grpVistAUsers.Name = "grpVistAUsers";
			this.grpVistAUsers.Size = new System.Drawing.Size(324, 256);
			this.grpVistAUsers.TabIndex = 7;
			this.grpVistAUsers.TabStop = false;
			this.grpVistAUsers.Text = "Select a Windows User*";
			// 
			// lvNtUsers
			// 
			this.lvNtUsers.Activation = System.Windows.Forms.ItemActivation.TwoClick;
			this.lvNtUsers.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvNtUsers.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						this.colNtLogin,
																						this.colName});
			this.lvNtUsers.FullRowSelect = true;
			this.lvNtUsers.HideSelection = false;
			this.lvNtUsers.Location = new System.Drawing.Point(8, 16);
			this.lvNtUsers.MultiSelect = false;
			this.lvNtUsers.Name = "lvNtUsers";
			this.lvNtUsers.Size = new System.Drawing.Size(308, 232);
			this.lvNtUsers.TabIndex = 3;
			this.lvNtUsers.View = System.Windows.Forms.View.Details;
			this.lvNtUsers.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvNtUsers_ColumnClick);
			this.lvNtUsers.SelectedIndexChanged += new EventHandler(lvNtUsers_SelectedIndexChanged);
			this.lvNtUsers.ItemActivate += new EventHandler(lvNtUsers_ItemActivate);
			// 
			// colNtLogin
			// 
			this.colNtLogin.Text = "NT Login";
			this.colNtLogin.Width = 118;
			// 
			// colName
			// 
			this.colName.Text = "Name";
			this.colName.Width = 184;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Image = null;
			this.btnCancel.Location = new System.Drawing.Point(256, 292);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(75, 23);
			this.btnCancel.TabIndex = 9;
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(176, 292);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 8;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// DlgWindowsUsers
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(332, 316);
			this.Controls.Add(this.grpVistAUsers);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.MinimumSize = new System.Drawing.Size(340, 340);
			this.Name = "DlgWindowsUsers";
			this.RequiredFieldsLabel = true;
			this.Text = "Windows Users";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpVistAUsers, 0);
			this.grpVistAUsers.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Load Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnLoad(EventArgs e)
		{
			base.OnLoad (e);

			this.Refresh();

			using( new WaitCursor() )
				LoadWindowsUsers();

			if( lvNtUsers.Items.Count == 0 ) 
				GuiUtility.SetListViewReadonlyErrorMessage( lvNtUsers, "No users found in the 'VBECS Users' local Windows group" );
			else
				GuiUtility.ReenableDetailedListView( lvNtUsers );

			UpdateOkButton();
			UpdateCancelButton();
		}

		private void LoadWindowsUsers()
		{
			lvNtUsers.BeginUpdate();

			lvNtUsers.Items.Clear();
			lvNtUsers.View = View.Details;

			string _loginIdToSelect = _initiallySelectedUser != null ? _initiallySelectedUser.UserNTLoginID : null;

			//Defect 251166 - using static property instead of local cached list to avoid double calls
			//				  should populate the forms faster. Its loaded in Main()
			foreach( VbecsWindowsUser _user in  VbecsWindowsUser.VbecsUsersADList)
			{
				WindowsUserListViewItem _lvi = new WindowsUserListViewItem( _user );
				lvNtUsers.Items.Add( _lvi );

				if( _user.LoginId == _loginIdToSelect )
					_lvi.Selected = true;
			}

			lvNtUsers.EndUpdate();
		}

		private void lvNtUsers_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			ColumnClickSorter.ColumnClickHandler( sender, e, true, ColumnClickSorter.ColumnSortType.String );
		}

		private void lvNtUsers_SelectedIndexChanged(object sender, EventArgs e)
		{
			UpdateOkButton();
		}

		private void lvNtUsers_ItemActivate(object sender, EventArgs e)
		{
			btnOK.PerformClick();
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			_selectedUser = ((WindowsUserListViewItem)lvNtUsers.SelectedItems[0]).WindowsUser;

			DialogResult = DialogResult.OK;
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{			
			_selectedUser = null;
		}

		private void UpdateCancelButton()
		{
			btnCancel.Enabled = true;
			SetThisToolTip( btnCancel, StrRes.Tooltips.MUC03.ClickToCancelWindowsUserSelection() );
		}

		private void UpdateOkButton()
		{
			btnOK.EnabledButton = IsValidSelectionMade;
			btnOK.SetToolTip( ( IsValidSelectionMade ? StrRes.Tooltips.MUC03.ClickToSelectWindowsUser() : StrRes.Tooltips.MUC03.PleaseSelectWindowsUser() ).ResString );
		}

		/// <summary>
		/// Get IsValidSelectionMade
		/// </summary>
		private bool IsValidSelectionMade
		{
			get
			{
				return ( lvNtUsers.View == View.Details ) && ( lvNtUsers.SelectedItems.Count > 0 );
			}
		}

		/// <summary>
		/// Get SelectedWindowsUser
		/// </summary>
		public VbecsWindowsUser SelectedWindowsUser
		{
			get
			{
				return _selectedUser;
			}
		}
	}
}
